/****** Object:  StoredProcedure [dbo].[P_EST_ARV_MERC_MIX_ANALISE_EVENTOS]    Script Date: 02/26/2014 19:52:06 ******/

IF EXISTS
(
    SELECT
           *
    FROM
         sys.objects
    WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_ARV_MERC_MIX_ANALISE_EVENTOS]')
          AND type IN(N'P', N'PC')
)
    DROP PROCEDURE
         [dbo].[P_EST_ARV_MERC_MIX_ANALISE_EVENTOS];
GO
GO

CREATE PROCEDURE P_EST_ARV_MERC_MIX_ANALISE_EVENTOS
(
                 @CD_EMP INT = 1
)
AS
     SET NOCOUNT ON;  
--EXEC P_EST_ARV_MERC_MIX_ANALISE_EVENTOS 1
     DECLARE @DT_ATUAL DATETIME;
     DECLARE @DT_INICIO DATETIME;
     DECLARE @DT_PROC DATETIME;
     DECLARE @DT_PROC_ANDAMENTO DATETIME;
     DECLARE @QTDE_MES INT;
     DECLARE @QTDE_MES_PROC AS INT;
     DECLARE @MES_PROC INT;
     DECLARE @ANO_PROC INT;
   
   
     IF NOT EXISTS( SELECT TOP 1 CD_EMP FROM EST_ARV_MERC_MIX_ANALISE_VENDAS )
		BEGIN
			SET @DT_ATUAL = dbo.F_INICIO_MES(GETDATE());
		END;
		ELSE
		BEGIN
			SET @DT_ATUAL = CONVERT(CHAR(10), GETDATE(), 112);
		END;

     SET @DT_INICIO = dbo.F_INICIO_MES(@DT_ATUAL);

     IF @DT_ATUAL = @DT_INICIO
         BEGIN
             SET @DT_PROC = DATEADD(m, -3, @DT_ATUAL);
             TRUNCATE TABLE EST_ARV_MERC_MIX_ANALISE_VENDAS;
         END;
         ELSE
         BEGIN
             SET @DT_PROC = DATEADD(d, -1, @DT_ATUAL);
             DELETE FROM EST_ARV_MERC_MIX_ANALISE_VENDAS
             WHERE
                   CD_EMP = @CD_EMP
                   AND MES = MONTH(@DT_PROC)
                   AND ANO = YEAR(@DT_PROC);
         END;


     PRINT 'Processando estoque rede '+CONVERT(VARCHAR, GETDATE(), 108);

     EXEC P_EST_ARV_MERC_MIX_ANALISE_ESTOQUE;
     
	 SET @QTDE_MES = DATEDIFF(m, @DT_PROC, @DT_ATUAL);
     SET @QTDE_MES_PROC = 0;
     
	 WHILE @QTDE_MES >= @QTDE_MES_PROC
         BEGIN
             SET @DT_PROC_ANDAMENTO = DATEADD(M, @QTDE_MES_PROC, @DT_PROC);
             SET @MES_PROC = MONTH(@DT_PROC_ANDAMENTO);
             SET @ANO_PROC = YEAR(@DT_PROC_ANDAMENTO);

             PRINT 'Processando mes '+CONVERT(VARCHAR, @MES_PROC)+'-'+CONVERT(VARCHAR, @ANO_PROC)+' '+CONVERT(VARCHAR, GETDATE(), 108);
             
			 EXEC P_EST_ARV_MERC_MIX_ANALISE_VENDAS                  @CD_EMP                , @MES_PROC                , @ANO_PROC;

			 SELECT
                    @QTDE_MES_PROC = @QTDE_MES_PROC + 1;
         END;